function [last_episodes, av_all_episodes]=simulation_rep_exclusion(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,K)

%In this exclusion case player 1 is an AMM, player 2 is a human playing
%the static best response to player 1 in each period.

%This function returns:

%last_episodes: a K x 6 matrix with the values in the last episode T of
%A_1, A_2, profit 1, profit 2, v_tilde, l, for every experiment.

%av_all_episodes: A Tx12 matrix containing for each episode t the mean across experiments 
%of A_1, A_2, opt_1, Profit_1, Profit_2, a_min, and the means of the squared values of these
%variables.

%Initialize
last_episodes = zeros(K,6);
av_all_episodes = zeros(T,12);

%Run K experiments.
%Replace "parfor" with "for" to run without parallelization.
parfor k=1:K
    %Calls the function simulation_exp_exclusion
    [last_episode,all_episodes] = simulation_exp_exclusion(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size);
    %Records the last episode 
    last_episodes(k,:) = last_episode;
    %Adds the values of all episodes to the existing av_all_episodes
    av_all_episodes = av_all_episodes + all_episodes;
    %Uncomment the next line to follow the execution of the code
    %disp(k)
end

%Divide av_all_episodes by K to get the average across all experiments:
av_all_episodes = av_all_episodes/K;
